#ifndef _WORLDCUP_H_
#define _WORLDCUP_H_

/*
 * constants for querying the 5-way navigator.
 */
#define fiveWayLeft   1028
#define fiveWayRight  2056
#define fiveWaySelect 4096

/*
 * main.c
 */
extern UInt32 romversion; 

#define FeatureSet20 (romversion >= 0x02003000)
#define FeatureSet30 (romversion >= 0x03003000)
#define FeatureSet31 (romversion >= 0x03103000)
#define FeatureSet35 (romversion >= 0x03503000)

/*
 * utils.c
 */
typedef void FormInitFunctionType(UInt16 msgID,UInt16 titleID);
void ButtonSetLabel(Int16 id, char *l);
char* GetString(UInt16 id);
void DisplayErrorMessage(UInt16 id);
void DisplayInformationMessage(UInt16 id);
UInt16 DisplayConfirmationMessage(UInt16 id);
void* Id2Ptr(UInt16 id);
void SetHandleInt(FieldType* fptr, Int32 n);
void SetTextFieldWithHandle(FieldPtr textFldP, MemHandle textH, Boolean drawIt);
Err SetTextFieldWithString(FieldPtr textFldP, char *string, Boolean drawIt);
void DrawButton(Int16 res, Int16 bitmapid);
void FldRecalculateScrollbar(FieldPtr fld, ScrollBarPtr scl);
void FldDoScrolling(FieldPtr fld, ScrollBarPtr scl);
void MyDoDialog(UInt16, FormEventHandlerType*, FormInitFunctionType*, UInt16, UInt16);

/*
 * worldcup.c
 */
typedef struct {
  Int16 version;
  Int16 options;
#define OPT_UseFrmMatches          1
#define OPT_AlternativeGroupLabels 2
  Int32 gmtOff;
  Int16 group, round;
} MyAppPreferencesType;

struct match {
  UInt8 group, team1, team2;
  Int8 r1, r2;
  UInt8 venue;
  UInt32 date;
};

struct player {
  char name[30];
  char team[32];
  DateType dateBirth;
  enum { Goal, Defense, Midfield, Forward, Coach } position;
  Int8 number;
};

struct team {
  char name[28];
  char abbr[4];
  char info[80];
};

struct venue {
  char name[24];
  UInt32 cap;
  UInt8 x, y;
};

struct teamstate {
  UInt16 Goals, OppGoals, Points;
  Int8 Matches, Pos, Won, Draw, Lost;
};

struct matchfield {
  FieldType *team1fld, *team2fld, *r1fld, *r2fld, *num;
  UInt8 team1, team2, team1Final, team2Final;
  Int8 r1, r2, venue;
  UInt32 date;
  UInt8 recNo;
};

void InitFrmHelp(UInt16 msgID, UInt16 titleID);
Boolean FrmHelpHandleEvent (EventPtr e);
Int8 ComputeTable(struct teamstate *table, struct matchfield *match,
		  Int8 who, Int8 recursive);
void ReadSetFixture(struct matchfield* match, UInt8 group, Boolean setallfields);
Boolean TimezoneFormHandleEvent(EventPtr e);
Boolean AboutFormHandleEvent(EventPtr e);
Boolean SpieltagFormHandleEvent(EventPtr e);
Boolean MainPopupFormHandleEvent(EventPtr e);

extern UInt8 selectedTeam;
extern Int8 selectedMatch;
extern Int32 defaultDateFormat;
extern MyAppPreferencesType appPrefs;
extern struct matchfield match[8];

/*
 * database.c
 */
struct prefs {
  UInt8 version;
};
extern struct prefs thePrefs;
extern DmOpenRef worldcupDB, worldcupPics, datebook;

Boolean OpenDatebook(void);
Boolean OpenDatabase(void);
char* ReadFixture(char*, struct match*);
void WriteFixture(struct matchfield *match, UInt8 num, UInt8 group);
void SetHandleString(FieldType *fptr, int num);
UInt8 ComputeSetHandleString(FieldType *fptr, int num);
struct team* GetTeamString(int num);
struct venue* GetLocation(int num);
UInt16 readPlayers(char *items[], UInt16 selectedTeam);
void SaveStatus(void);
void BeamDatabase(void);

/*
 * teams.c
 */
Boolean TeamsFormHandleEvent(EventPtr e);
Boolean PlayerFormHandleEvent(EventPtr e);

/*
 * stadium.c
 */
Boolean ShowStadiumFormHandleEvent(EventPtr e);

/*
 * matches.c
 */
void SetMatchesListTeamString(Int16 num, char *p, char *buf);
void MakeDatebookEntry(UInt32 secs, Int16 n);
Boolean MatchesFormHandleEvent(EventPtr e);

/*
 * fixture.c
 */
Boolean FixtureFormHandleEvent(EventPtr e);

#endif
