/*
 * Worldcup is Copyright (c) 2001-2006 by Thomas Pundt
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without a written agreement is hereby granted,
 * provided that the above copyright notice and this paragraph and the
 * following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 * THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <PalmOS.h>

#include "worldcup.h"
#include "worldcuprcp.h"

static char* items[25] = { 0, };
static Int16 selectedPlayer;

/**
 * Teams Form
 */
static void 
DrawTeamList(Int16 itemNum, RectangleType *bounds, Char **itemsText)
{
  Char buf[35];
  struct player *p = (struct player*) itemsText[itemNum];
  if (p) {
    if (p->number) {
      StrPrintF(buf,"%s (%d)", p->name, p->number);
    } else {
      StrCopy(buf,p->name);
    }
    WinDrawChars(buf,StrLen(buf),bounds->topLeft.x,bounds->topLeft.y);
  }
}

static void 
DrawMatchesList(Int16 itemNum, RectangleType *bounds, Char **itemsText)
{
  Char buf[64], *p, *q;
  MemHandle handle;
  UInt32 n, num;
  Int16 e1, e2;

  n = (UInt32)itemsText[itemNum];
  if ( (handle = DmQueryRecord(worldcupDB,3)) ) {
    p = q = MemHandleLock(handle);
    MemHandleUnlock(handle);

    if ( (num = (n%256)) < 112) {
      SetMatchesListTeamString(num,p,buf);      
      StrCat(buf,"-");
      SetMatchesListTeamString((n>>8)&0xff,q,buf+StrLen(buf));
      if ((n & 0xff0000) != 0xff0000) {
	e1 = (n>>16)&0xff;
	e2 = n>>24;
	StrPrintF(buf+StrLen(buf)," %d:%d", e1, e2);
      }
    } else {
      if (num<120) {
	StrCopy(buf,GetString(IdRoundString+2));
      } else if (num<125) {
	StrCopy(buf,GetString(IdRoundString+3));
      } else {
	StrCopy(buf,GetString(IdRoundString+4));
      }
    }
  }
  WinDrawChars(buf,StrLen(buf),bounds->topLeft.x,bounds->topLeft.y);
}

static UInt16
readMatches(char *items[], UInt16 selectedTeam)
{
  struct match Match;
  char *p;
  UInt8 i = 0, m1, m2;
  for (p=ReadFixture(0, &Match); p; p=ReadFixture(p, &Match)) {
    if (Match.group>0) {
      m1=(Match.group-1)*4+Match.team1;
      m2=(Match.group-1)*4+Match.team2;
    } else {
      m1=ComputeSetHandleString(0, Match.team1);
      m2=ComputeSetHandleString(0, Match.team2);
    }
    if ( m1 == selectedTeam || m2 == selectedTeam)
      items[i++] = (char*)((UInt32)m1+(UInt32)(m2<<8)
			   +((UInt32)Match.r1<<16)+((UInt32)Match.r2<<24));
  }
  return i;
}

Boolean TeamsFormHandleEvent(EventPtr e)
{
  Boolean handled;
  static FormPtr frm;
  ListPtr p;
  FieldPtr fld;
  UInt16 nrOfItems;
  RectangleType rect;
  struct team* team;
  void *hBmp;
  static Boolean teamMode;

  handled = false;
  switch (e->eType) {

  case frmOpenEvent:
    frm = FrmGetActiveForm();
    team = GetTeamString(selectedTeam);
    FrmCopyTitle(frm,team->name);
    nrOfItems = readPlayers(items,selectedTeam);
    teamMode = true;

    p = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, IdFrmTeams+1));
    LstSetListChoices(p, items, nrOfItems);
    LstSetHeight(p, nrOfItems>8?8:nrOfItems);
    LstSetDrawFunction(p, DrawTeamList);

    fld = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, IdFrmTeams+2));
    FldSetTextPtr(fld, team->info);
    FldRecalculateField(fld,true);
    FldGetBounds(fld, &rect);
    rect.extent.y = FldCalcFieldHeight(team->info,rect.extent.x)*FntLineHeight();
    FldSetBounds(fld, &rect);

    FrmDrawForm(frm);

    if ( (hBmp = DmGetResource((UInt32)'Tbmp',IdFlag+selectedTeam)) ) {
      WinDrawBitmap(MemHandleLock(hBmp),1,13);
      MemHandleUnlock(hBmp);
      DmReleaseResource(hBmp);
    }

    handled = true; 
    break;

  case ctlSelectEvent:
    if (e->data.ctlSelect.controlID == IdFrmTeams) {
      FrmReturnToForm(0);
      handled = true; 
    }
    if (e->data.ctlSelect.controlID == IdFrmTeams+3) {
      teamMode = !teamMode;
      p = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, IdFrmTeams+1));
      LstEraseList(p);
      if (teamMode) {
	nrOfItems = readPlayers(items,selectedTeam);
	LstSetDrawFunction(p, DrawTeamList);
      } else {
	nrOfItems = readMatches(items,selectedTeam);
	LstSetDrawFunction(p, DrawMatchesList);
      }
      LstSetListChoices(p, items, nrOfItems);
      LstSetHeight(p, nrOfItems>8?8:nrOfItems);
      LstDrawList(p);
      handled = true; 
    }
    break;

  case lstSelectEvent:
    if (teamMode) {
      selectedPlayer = e->data.lstSelect.selection;
      FrmPopupForm(IdFrmPlayer);
    }
    handled = true;
    break;

  default:
    break;
  }

  return handled;
}

/**
 * Player Form
 */
Boolean PlayerFormHandleEvent(EventPtr e)
{
  Boolean handled;
  static FormType *frm;
  struct player *player;
  static char dateBuffer[12];
  static char posBuffer[24];
  void *hBmp;
  
  handled = false;
  switch (e->eType) {

  case frmOpenEvent:
    frm = FrmGetActiveForm();
    player = (struct player*) items[selectedPlayer];
    if ( player->dateBirth.year ) {
      DateToAscii(player->dateBirth.month,
		  player->dateBirth.day,
		  player->dateBirth.year+1904,
		  defaultDateFormat,
		  dateBuffer);
    } else {
      StrCopy(dateBuffer,"");
    }

    if (player->number>0) {
      StrPrintF(posBuffer,"%s (%d)",
		GetString(IdPositionString+player->position),
		player->number);
    } else {
      StrCopy(posBuffer,GetString(IdPositionString+player->position));
    }
    SetTextFieldWithString(Id2Ptr(IdFrmPlayer+1), player->name, false);
    SetTextFieldWithString(Id2Ptr(IdFrmPlayer+2), posBuffer, false);
    SetTextFieldWithString(Id2Ptr(IdFrmPlayer+3), player->team, false);
    SetTextFieldWithString(Id2Ptr(IdFrmPlayer+4), dateBuffer, false);
    FrmDrawForm(frm);
    if ( (hBmp = DmGetResource('Tbmp',IdPlayer+(selectedTeam-1)*25+selectedPlayer)) ) {
      WinDrawBitmap(MemHandleLock(hBmp),55,70);
      MemHandleUnlock(hBmp);
      DmReleaseResource(hBmp);
    }
    handled = true; 
    break;

  case ctlSelectEvent:
    if (e->data.ctlSelect.controlID == IdFrmPlayer) {
      FrmReturnToForm(0);
      handled = true; 
    }
    break;

  default:
    break;
  }

  return handled;
}

