/*
 * Worldcup is Copyright (c) 2001-2006 by Thomas Pundt
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without a written agreement is hereby granted,
 * provided that the above copyright notice and this paragraph and the
 * following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 * THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <PalmOS.h>

#include "worldcup.h"
#include "worldcuprcp.h"

void ShowStadiumFormInitForm(UInt16 selectedStadium)
{
  void *hBmp;
  Int16 row,fld;
  char *p, buf[10];
  struct match Match;
  struct team *team;
  struct venue* venue = GetLocation(selectedStadium-1);

  FrmDrawForm(FrmGetActiveForm());
  FrmSetTitle(FrmGetActiveForm(), venue->name); // (sr) 2010: to save space, staduim name is the form title
  //SetTextFieldWithString(Id2Ptr(IdFrmStadium+1),venue->name,true);
  SetHandleInt(Id2Ptr(IdFrmStadium+2),venue->cap);
  FldDrawField(Id2Ptr(IdFrmStadium+2));
  if ( (hBmp = DmGetResource((UInt32)'Tbmp',IdGermany+1)) ) {
    WinDrawBitmap(MemHandleLock(hBmp),venue->x,venue->y+15);
    MemHandleUnlock(hBmp);
    DmReleaseResource(hBmp);
  }
  
  // every stadium has max 8 venues; clear last fields in case of only 5 venues.
  // (sr) 2010: changed to max 8 venues. TODO : Hide unused fields
  SetTextFieldWithString(Id2Ptr(IdFrmStadium+8)," ",true);
  SetTextFieldWithString(Id2Ptr(IdFrmStadium+9)," ",true);
  SetTextFieldWithString(Id2Ptr(IdFrmStadium+10)," ",true);

  fld = 3;
  for ( p=ReadFixture(0,&Match),row=0; p; p=ReadFixture(p,&Match),row++ ) {
    if (row>63) continue;
    if (Match.venue == selectedStadium) {
      if (Match.group>0) {
	team = GetTeamString((Match.group-1)*4+Match.team1);
	StrCopy(buf,team->abbr);
	StrCat(buf,"-");
	team = GetTeamString((Match.group-1)*4+Match.team2);
	StrCat(buf,team->abbr);
	SetTextFieldWithString(Id2Ptr(IdFrmStadium+fld),buf,true);
      } else {
	if (Match.team1<=48) {
	  StrCopy(buf,"1/8 Fin");
	} else if (Match.team1<=56) {
	  StrCopy(buf,"1/4 Fin");
	} else if (Match.team1<=60) {
	  StrCopy(buf,"1/2 Fin");
	} else if (Match.team1 == 161) {
	  StrCopy (buf, "3rd Pl");
	} else {
	  StrCopy (buf, "Final");
	}
	SetTextFieldWithString(Id2Ptr(IdFrmStadium+fld),buf,true);
      }
      fld++;
    }
  }
}

/**
 * Show Stadium Form
 */
Boolean ShowStadiumFormHandleEvent(EventPtr e)
{
  Boolean handled;
  struct venue* venue;
  Int16 i;
  
  handled = false;
  switch (e->eType) {

  case frmOpenEvent:
    ShowStadiumFormInitForm(match[selectedMatch].venue);
    handled = true; 
    break;

  case ctlSelectEvent:
    if (e->data.ctlSelect.controlID == IdFrmStadium) {
      FrmReturnToForm(0);
      handled = true; 
    }
    break;

  case penUpEvent:
    for (i=0;i<10;i++) /* (sr) 2010 changed to 10 Stadiums */ {
      venue = GetLocation(i);
      if (e->data.penUp.end.x >= venue->x-5 && e->data.penUp.end.x <= venue->x+7 && 
          e->data.penUp.end.y >= venue->y+9 && e->data.penUp.end.y <= venue->y+21) {
	ShowStadiumFormInitForm(i+1);
	handled = true;
	break;
      }
    }
    break;

  default:
    break;
  }

  return handled;
}

