/*
 * Worldcup is Copyright (c) 2001-2006 by Thomas Pundt
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without a written agreement is hereby granted,
 * provided that the above copyright notice and this paragraph and the
 * following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 * THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <PalmOS.h>

#include "worldcup.h"
#include "worldcuprcp.h"

static void DebugModeDummy(void) __attribute__ ((__section__("dummyfns")));
static void DebugModeDummy(void) {}

UInt32 romversion;

static Boolean ApplicationHandleEvent(EventPtr e)
{
  Boolean handled = false;

  if (e->eType == frmLoadEvent) {
    UInt16 frmId = e->data.frmLoad.formID;
    FormPtr frm = FrmInitForm(frmId);

    FrmSetActiveForm(frm);

    switch (frmId) {

    case IdFrmMain:
      FrmSetEventHandler(frm, SpieltagFormHandleEvent);
      handled = true; 
      break;

    case IdFrmAbout:
      FrmSetEventHandler(frm, AboutFormHandleEvent);
      handled = true; 
      break;

    case IdFrmStadium:
      FrmSetEventHandler(frm, ShowStadiumFormHandleEvent);
      handled = true; 
      break;

    case IdFrmTeams:
      FrmSetEventHandler(frm, TeamsFormHandleEvent);
      handled = true; 
      break;

    case IdFrmPlayer:
      FrmSetEventHandler(frm, PlayerFormHandleEvent);
      handled = true; 
      break;

    case IdFrmTimezone:
      FrmSetEventHandler(frm, TimezoneFormHandleEvent);
      handled = true; 
      break;

    case IdFrmMatches:
      FrmSetEventHandler(frm, MatchesFormHandleEvent);
      handled = true;
      break;

    case IdFrmFixture:
      FrmSetEventHandler(frm, FixtureFormHandleEvent);
      handled = true;
      break;

    case IdFrmMainPopup:
      FrmSetEventHandler(frm, MainPopupFormHandleEvent);
      handled = true;
      break;

    }
  }

  return handled;
}

static Int16 StartApplication(void)
{
  UInt16 size;

  defaultDateFormat = PrefGetPreference(prefDateFormat);

  size = sizeof(appPrefs);
  // check for same version.
  if ( PrefGetAppPreferences('tpWC',0,&appPrefs,&size,false) != 1 ) {
    appPrefs.version = 1;
    appPrefs.options = 0;
    appPrefs.group   = 1;
    appPrefs.round   = 0;

    appPrefs.gmtOff = PrefGetPreference(prefMinutesWestOfGMT)/30L;
    appPrefs.gmtOff *= 1800L;
    if (appPrefs.gmtOff>12L*3600L) 
      appPrefs.gmtOff -= 24L*3600L;
    if (PrefGetPreference(prefDaylightSavings)>0) 
      appPrefs.gmtOff += 3600L;
  }

  if ( appPrefs.gmtOff > 52200L || appPrefs.gmtOff < -45000L )
    appPrefs.gmtOff = 0L;

  if (!OpenDatabase()) {
    return 1;
  }
  return 0;
}

static void EventLoop(void)
{
  EventType e;
  short err;

  do {
    EvtGetEvent(&e, evtWaitForever);
    if (! SysHandleEvent (&e))
      if (! MenuHandleEvent (NULL, &e, &err))
        if (! ApplicationHandleEvent (&e))
          FrmDispatchEvent (&e);
  } while (e.eType != appStopEvent);
}

UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags)
{
  UInt32 err;
  if (cmd == sysAppLaunchCmdNormalLaunch) {

    // check ROM version; we need at least 3.0.
    err = FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romversion);
    if ( FeatureSet20 ) {
      UInt32 depth = 0;
      err = StartApplication();
      if (err) return 0;
      
      if ( FeatureSet30 ) {
	// find out what color depths the device supports
	err = WinScreenMode (winScreenModeGetSupportedDepths,
			     NULL, NULL, &depth, NULL );
      
	// older 3.x ROM's seem to only support 4 color greyscale
	if (depth<4) {
	  depth = 2;
	} else if (depth<16) {
	  depth = 4;
	}
	// change color depth
	err = WinScreenMode( winScreenModeSet, 
			     NULL, NULL, &depth, NULL );
      }
      
      if (appPrefs.options & OPT_UseFrmMatches) 
	FrmGotoForm(IdFrmMatches);
      else
	FrmGotoForm(IdFrmMain);

      EventLoop();
      FrmCloseAllForms();
      SaveStatus();

      if ( FeatureSet30 ) {
	WinScreenMode( winScreenModeSetToDefaults, 
		       NULL, NULL, NULL, NULL );
      }
      
    } else {
      // no appropriate ROM found. Inform the user about that
      // and exit the program.
      DisplayErrorMessage(IdErrorMsg+3);
    }
    
  } else {
    return sysErrParamErr;
  }
  
  return 0;

}
