/*
 * Worldcup is Copyright (c) 2001-2006 by Thomas Pundt
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose, without fee, and without a written agreement is hereby granted,
 * provided that the above copyright notice and this paragraph and the
 * following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 * THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <PalmOS.h>

#include "worldcup.h"
#include "worldcuprcp.h"

/**
 * Show Fixture Overview Form
 */

static void DrawFixtureTableItem(void* tableP, Int16 row, Int16 column, 
				 RectangleType *bounds)
{
  Char buf[4];
  Int16 n = TblGetItemInt(tableP, row, column);
  struct team *team = GetTeamString(n);
  MemMove(buf,team->abbr,4);
  WinDrawChars(buf, StrLen(buf), bounds->topLeft.x, bounds->topLeft.y);
}

static void FixtureFormInitTables(void)
{
  Int16 Pos, g, n, row=0;
  struct matchfield match[6];
  struct teamstate standings[4];
  TablePtr fixtureTable = Id2Ptr(IdFrmFixture);
  static Int8 groupOrder[] = {1,2,3,4,5,6,7,8};

  for (g=0; g<8; g++) {
    if (g==4) fixtureTable = Id2Ptr(IdFrmFixture+1);
    TblSetRowUsable(fixtureTable, g%4, true);
    TblSetRowSelectable(fixtureTable, g%4, false);
    ReadSetFixture(match,groupOrder[g],false);
    ComputeTable(standings, match, 15, 0); // 15 => all bits set, all teams
    row = 0;
    for (Pos=1; Pos<=4; Pos++) {
      for (n=0; n<4; n++) {
	if (standings[n].Pos == Pos) {
	  TblSetItemInt(fixtureTable, row, g%4, (groupOrder[g]-1)*4+n+1);
	  TblSetItemStyle(fixtureTable, row, g%4, customTableItem);
	  TblSetColumnUsable(fixtureTable, g%4, true);
	  TblSetCustomDrawProcedure(fixtureTable, g%4, DrawFixtureTableItem);
	  row++;
	}
      }    
    }
  }
}


Boolean FixtureFormHandleEvent(EventPtr e)
{
  Boolean handled;
      RGBColorType rgb, save;
  static int cY[]={15,32,49,66,91,108,125,142};
  UInt8 i;
  
  handled = false;
  switch (e->eType) {

  case frmOpenEvent:
    if ( FeatureSet35 ) {
      UIColorGetTableEntryRGB(UIFieldBackground, &save);
      rgb.r = 0x98; rgb.g = 0xcc; rgb.b = 0xf8;
      UIColorSetTableEntry(UIFieldBackground, &rgb); 
    }
    FixtureFormInitTables();
    FrmDrawForm(FrmGetActiveForm());

    DrawButton(IdFrmFixture+2,IdBitmap+10);
    DrawButton(IdFrmFixture+3,IdBitmap+12);
    DrawButton(IdFrmFixture+4,IdBitmap+15);

    if ( FeatureSet35 ) {
      UIColorSetTableEntry(UIFieldBackground, &save); 
    } else {
      RectangleType rect;
      rect.topLeft.x = 1;
      rect.topLeft.y = 15;
      rect.extent.x = 95;
      rect.extent.y = 67;
      WinDrawRectangleFrame(simpleFrame,&rect);
      rect.topLeft.y = 91;
      WinDrawRectangleFrame(simpleFrame,&rect);
      rect.topLeft.x = 101;
      rect.extent.x = 39;
      rect.extent.y = 16;
      for (i=0; i<8; i++) {
	rect.topLeft.y = cY[i];
	WinDrawRectangleFrame(simpleFrame,&rect);
      }
    }

    handled = true; 
    break;

  case menuEvent:

    switch(e->data.menu.itemID) {

    case IdMenuItem:
      FrmPopupForm(IdFrmAbout);
      break;

    case IdMenuItem+2:
      FrmPopupForm(IdFrmTimezone);
      break;

    case IdMenuItem+3:
      FrmGotoForm(IdFrmMain);
      break;

    case IdMenuItem+4:
      FrmGotoForm(IdFrmMatches);
      break;

    case IdMenuItem+5:
      BeamDatabase();
      break;

    }
    handled = true;
    break;

  case ctlSelectEvent:
    switch (e->data.ctlSelect.controlID) {
    case IdFrmFixture+2: // "Groups form" button
      FrmGotoForm(IdFrmMain);
      break;
    case IdFrmFixture+3: // "Matches form" button
      FrmGotoForm(IdFrmMatches);
      break;
    }
    handled = true;
    break;

  case keyDownEvent:
    if (e->data.keyDown.chr == vchrRockerLeft ||
        e->data.keyDown.keyCode == fiveWayLeft) {
      FrmGotoForm(IdFrmMatches);
      handled = true;
    }

    if (e->data.keyDown.chr == vchrRockerRight ||
        e->data.keyDown.keyCode == fiveWayRight) {
      FrmGotoForm(IdFrmMain);
      handled = true;
    }

    break;

  default:
    break;
  }

  return handled;
}

