/******************************************************************************
 *
 * Copyright (c) 1995-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 *
 * File: DateDB.h
 *
 * Release: Palm OS SDK 4.0 (63220)
 *
 * Description:
 *		Header for the Appointment Manager
 *
 * History:
 *   	1/25/95  rsf - Created
 *
 *****************************************************************************/

#ifndef __TDAPPTMGR_H__
#define __TDAPPTMGR_H__

/* Repeat types */
enum repeatTypes {
  repeatNone,
  repeatHourly,
  repeatDaily,
  repeatWeekly,
  repeatMonthlyByDay,
  repeatMonthlyByDate,
  repeatYearly
};
typedef enum repeatTypes RepeatType;

/* Repeat info type (DateBook version) */
typedef struct {
  RepeatType repeatType;   // daily, weekly
  UInt8 reserved1;
  DateType repeatEndDate;  // minus one if forever
  UInt8 repeatFrequency;   // i.e. every 2 days if repeatType daily  
  UInt8 repeatOn;          // monthlyByDay and repeatWeekly
  UInt8 repeatStartOfWeek; // repeatWeekly only
  UInt8 reserved2;
} DtbkRepeatInfoType;
typedef DtbkRepeatInfoType * DtbkRepeatInfoPtr;

typedef struct {
  UInt16 renamedCategories;	// bitfield of categories with a different name
  char 	categoryLabels[dmRecNumCategories][dmCategoryLength];
  UInt8	categoryUniqIDs[dmRecNumCategories];
  UInt8	lastUniqID;	// Uniq IDs generated by the device are between
                        // 0 - 127.  Those from the PC are 128 - 255.
  UInt8	reserved1;	// from the compiler word aligning things
  UInt16 reserved2;
  UInt8	startOfWeek;
  UInt8	reserved;
} ApptAppInfoType;
typedef ApptAppInfoType * ApptAppInfoPtr;


/************************************************************
 * Appointment Database constants.
 *************************************************************/
#define apptMaxPerDay 	100	// max appointments displayable on a day.
#define apptNoTime	-1	// start time of an untimed appt.
#define apptNoEndDate	0xffff	// end date of appts that repeat forever
#define apptNoAlarm	-1
#define apptMaxEndTime	0x1737	// 11:55 pm, hours in high byte, minutes in low byte
#define apptDawnOfTime	0
#define apptEndOfTime	0xffffffff

#define apptMaxDisplayableAlarms 10


/************************************************************
 * Appointment Database structures.
 *************************************************************/

// The format of a packed appointment record is as follows:
//
// ApptDateTimeType 	when;
// ApptDBRecordFlags	flags;		// A flag set for each datum present
// AlarmInfoType	alarm;		// optional
// RepeatInfoType	repeat;		// optional
// ExceptionsListType	exceptions;	// optional
// char []		note;		// null terminated, optional
// char []		description;	// null terminated
//
// All optional data may or may not appear.



// Alarm advance - the period of time before the appointment that the 
// alarm should sound.
//
typedef enum alarmTypes {aauMinutes, aauHours, aauDays} AlarmUnitType;

typedef struct {
  Int8	advance; // Alarm advance (-1 = no alarm)
  AlarmUnitType	advanceUnit; // minutes, hours, days
} AlarmInfoType;


// This structure contains information about the date and time of an 
// appointment.
//
typedef struct {
  TimeType startTime; // Time the appointment starts
  TimeType endTime;   // Time the appointment ends
  DateType date;      // date of appointment
} ApptDateTimeType;



// This is the structure for a repeating appointment's exceptions list.  The
// exceptions list is a variable length list of dates that the repeating appointment
// should not appear on.  The list is in chronological order.
//
typedef struct {
  UInt16    	numExceptions;
  DateType	exception;
} ExceptionsListType;

typedef ExceptionsListType * ExceptionsListPtr;



// This structure describes what information is present in an
// AppointmentPackedDBRecordType
typedef struct {
  unsigned when:1;		// set if when info changed (ApptChangeRecord)
  unsigned alarm:1;		// set if record contains alarm info
  unsigned repeat:1;		// set if record contains repeat info
  unsigned note:1;		// set if record contains a note
  unsigned exceptions:1;	// set if record contains exceptions list
  unsigned description:1;			
} ApptDBRecordFlags;


// ApptDBRecordType
//
// This is the record used by the application.  All pointers are either NULL 
// or point to data within the PackedDB record.  All strings are null 
// character terminated.

typedef struct {
  ApptDateTimeType *when;
  AlarmInfoType *alarm;
  DtbkRepeatInfoType *repeat;
  ExceptionsListType *exceptions;
  Char *description;
  Char *note;
} ApptDBRecordType;

typedef ApptDBRecordType * ApptDBRecordPtr;


// ApptGetAppointments returns an array of the following structures.
typedef struct {
  TimeType startTime;
  TimeType endTime;
  UInt16 recordNum;
} ApptInfoType;
typedef ApptInfoType * ApptInfoPtr;



/************************************************************
 *
 * Appointment database routines.
 *
 *************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

Err ApptNewRecord (DmOpenRef dbP, ApptDBRecordPtr r, UInt16 *index);

#ifdef __cplusplus
}
#endif

#endif
