#!/usr/bin/perl
use PDA::Pilot; # from the pilot-link package.
use POSIX qw(mktime);

my %team = (
'A1'=> { 'no' => '1', 'abb' => 'RSA' },
'A2'=> { 'no' => '2', 'abb' => 'MEX' },
'A3'=> { 'no' => '3', 'abb' => 'URU' },
'A4'=> { 'no' => '4', 'abb' => 'FRA' },
'B1'=> { 'no' => '1', 'abb' => 'ARG' },
'B2'=> { 'no' => '2', 'abb' => 'NGA' },
'B3'=> { 'no' => '3', 'abb' => 'KOR' },
'B4'=> { 'no' => '4', 'abb' => 'GRE' },
'C1'=> { 'no' => '1', 'abb' => 'ENG' },
'C2'=> { 'no' => '2', 'abb' => 'USA' },
'C3'=> { 'no' => '3', 'abb' => 'ALG' },
'C4'=> { 'no' => '4', 'abb' => 'SVN' },
'D1'=> { 'no' => '1', 'abb' => 'GER' },
'D2'=> { 'no' => '2', 'abb' => 'AUS' },
'D3'=> { 'no' => '3', 'abb' => 'SRB' },
'D4'=> { 'no' => '4', 'abb' => 'GHA' },
'E1'=> { 'no' => '1', 'abb' => 'NED' },
'E2'=> { 'no' => '2', 'abb' => 'DEN' },
'E3'=> { 'no' => '3', 'abb' => 'JPN' },
'E4'=> { 'no' => '4', 'abb' => 'CMR' },
'F1'=> { 'no' => '1', 'abb' => 'ITA' },
'F2'=> { 'no' => '2', 'abb' => 'PAR' },
'F3'=> { 'no' => '3', 'abb' => 'NZL' },
'F4'=> { 'no' => '4', 'abb' => 'SVK' },
'G1'=> { 'no' => '1', 'abb' => 'BRA' },
'G2'=> { 'no' => '2', 'abb' => 'PRK' },
'G3'=> { 'no' => '3', 'abb' => 'CIV' },
'G4'=> { 'no' => '4', 'abb' => 'POR' },
'H1'=> { 'no' => '1', 'abb' => 'ESP' },
'H2'=> { 'no' => '2', 'abb' => 'SUI' },
'H3'=> { 'no' => '3', 'abb' => 'HON' },
'H4'=> { 'no' => '4', 'abb' => 'CHI' },
);

my %stadium = (
   1 => { "x"=>99, "y"=>40, "c"=>84490 },
   2 => { "x"=>96, "y"=>41, "c"=>55686 },
   3 => { "x"=>124,"y"=>35, "c"=>40929 },
   4 => { "x"=>90, "y"=>33, "c"=>38646 },
   5 => { "x"=>85, "y"=>67, "c"=>40911 },
   6 => { "x"=>20, "y"=>110,"c"=>64100 },
   7 => { "x"=>124,"y"=>75, "c"=>62760 },
   8 => { "x"=>112,"y"=>19, "c"=>41733 },
   9 => { "x"=>76, "y"=>110,"c"=>42486 },
  10 => { "x"=>102,"y"=>35, "c"=>42858 },
#  11 => { "x"=>58, "y"=>107, "c"=>66000 },
#  12 => { "x"=>42, "y"=>22, "c"=>50000 },
);

sub UInt32
{
  return sprintf("%c%c%c%c", ($_[0] & 0xff000000)>>24,
		 ($_[0] & 0xff0000)>>16,
		 ($_[0] & 0xff00)>>8,
		 ($_[0] & 0xff));
}

sub UInt16
{
  return sprintf("%c%c", ($_[0] & 0xff00)>>8,
		 ($_[0] & 0xff));
}

sub UInt8
{
  return sprintf("%c", ($_[0] & 0xff));
}

$secs_since_70 = 24107 * 86400; # - 28800; # Japan/Korea
$state = 0;

%info = ("type"=>"Data","creator"=>"tpWC","name"=>"worldcupDB");
$pdb = PDA::Pilot::File::create("worldcupDB.pdb", \%info )
  or die "something went wrong\n";

$rec = "\4";
$pdb->addRecordRaw($rec,0,0,0);
$rec = "";

%posEnum = ('G'=>0,'D'=>1,'M'=>2,'F'=>3,'C'=>4);

open FILE,"matches.txt" or die "oops\n";
while(<FILE>) {
  chomp();
  @args = split(/:/);
  $date = "";
  if ($args[6] && $args[6] =~ /^(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})/) {
    $date = mktime(0, $5, $4, $3, $2-1, $1-1900) + $secs_since_70;
  }
  $args[6] = UInt32($date);
  $args[3] = 255 if ($args[3] == -1 or $args[3] eq "");
  $args[4] = 255 if ($args[4] == -1 or $args[4] eq "");
  $args[1] = $team{$args[1]}->{no} if ($args[0]>0);
  $args[2] = $team{$args[2]}->{no} if ($args[0]>0);
  $rec .= sprintf("%c%c%c%c%c%c%s", @args);
}
close FILE;

while(<STDIN>) {
  chomp();
  next if (/^\s*#/);

  if (/^$/) {
    $state++;
    $pdb->addRecordRaw($rec,$state,0,0);
    $rec = "";
    next;
  }

  # read in stadium/place information
  if ($state == 1) {
    ($id,$place) = split(/:/);
    
    $rec .= $place . "\0" x (24-length($place)) . UInt32($stadium{$id}->{c}) 
         .  UInt8($stadium{$id}->{x}) . UInt8($stadium{$id}->{y});
  }

  # team name localization and comments
  if ($state == 2) {
    @args = split(/:/,$_,3);
    $args[1] = substr($args[1],0,19);
    $args[2] = substr($args[2],0,79);
    $rec .= $args[1] . "\0" x (28-length($args[1])) . 
            $team{$args[0]}->{abb} . "\0" .
            $args[2] . "\0" x (80-length($args[2]));
  }

  # the team members
  if ($state > 2) {
    @args = split(/:/);
    next if ($#args<1);
    $date = 0;
    if ($args[3] && $args[3] =~ /^(\d{4})(\d{2})(\d{2})/) {
      $date = $3 + ($2<<5) + (($1-1904)<<9);
    }

    if (length($args[1])>29 or length($args[2])>31) {
      print "too long: $args[1] (".length($args[1]).")/$args[2] (".length($args[2]).")\n";
      next;
    }
    $rec .= $args[1] . "\0" x (30-length($args[1])) .
            $args[2] . "\0" x (32-length($args[2])) .
            UInt16($date) .
            chr($posEnum{$args[0]}) . chr($args[4]);
  }

}

